/*-------------------------------------------------------------------*/
/*                                                                   */
/*   Turbo Vision 1.0                                                */
/*   Turbo Vision Demo                                               */
/*   Copyright (c) 1991 by Borland International                     */
/*                                                                   */
/*   BGI support file for use with Turbo Vision BGI (TVBGI) program. */
/*-------------------------------------------------------------------*/

#define Uses_TProgram
#include <tv.h>

#if !defined( __GRAPHAPP_H )
#include "Graphapp.h"
#endif  // __GRAPHAPP_H

#if !defined( __STRING_H )
#include <string.h>
#endif  // __STRING_H

#if !defined( __FSTREAM_H )
#include <fstream.h>
#endif  // __FSTREAM_H

#if !defined( __STRSTREA_H )
#include <strstrea.h>
#endif  // __STRSTREA_H

#if !defined( __IO_H )
#include <io.h>
#endif  // __IO_H

#include "BGI2.h"
//Utility functions



typedef void(*function)();


//------------------------------------------------------------------//
// Init BGI. If loadAtInit is true, try to locate and load driver.  //
// Returns true if LoadAtInit succeeds or is set to False. Does     //
// not "own" bgiPath, but instead is passed a pointer to a string   //
// that is allocated elsewhere. Does not de-allocate bgiPath when   //
// done.                                                            //
//------------------------------------------------------------------//

Boolean graphAppInit( int aDriver, int aMode,
            char *aBGIPath, Boolean loadAtInit )
{
    if (aBGIPath != 0)
        bgiPath = aBGIPath;
    driver = aDriver;
    mode = aMode;
    if ( loadAtInit == True )
    {
        if ( driver == 0 )
            detectgraph(&driver, &mode);
        if ( BGI_LoadDriver(driver,aBGIPath)==NULL ) return False;
    }
    if ( driver > 0 )
       return True;
    else
       return False;
}

void graphAppDone()
{
    if ( graphActive == True )
        closegraph();
    graphActive = False;
    bgiPath = emptyString;
    driver = DETECT;
    mode = 0;
}

void graphicsStop(void);

Boolean graphicsStart(void)
{
    if ( graphActive == True )
        return(True);

    initgraph( &driver, &mode, bgiPath );

    if ( driver < 0 )
        {
        graphicsStop();
        return False;
        }
    else
        graphActive = True;
    return True;
}

Boolean graphicsActive(void)
{
    if ( graphActive == True )
        return True;
    else
        return False;
}

void graphicsStop(void)
{
    if ( graphActive == True )
        closegraph();

    graphActive = False;
    TProgram::application->redraw();
}

