
#define Uses_TKeys
#define Uses_TScrollBar
#define Uses_TRect
#define Uses_TDrawBuffer
#define Uses_TEvent
#define Uses_TDialog
#define Uses_TCollection
#define Uses_TPoint
#define Uses_TButton
#define Uses_TProgram

#include <tv.h>

#include "tv2.h"
#include <stdlib.h>
#include <string.h>


// TInput_float:: ~TInput_float ()
// { ~TInputLine() };


/*====================================*/
void   TInput_float::getData(void *rec)
/*====================================*/
{
   *(float*)rec = atof(data);
}

/*====================================*/
void   TInput_float::setData(void *rec)
/*====================================*/
{  char s[16];
   gcvt ( *(float*)rec, 4, s);
   if ( strlen(s)<=maxLen ) strcpy(data,s);
   else                     strcpy(data,"?");
}

/*============================*/
ushort TInput_float::dataSize()
/*============================*/
{
   return sizeof(float);
}


void TDialogDbl::handleEvent(TEvent& event)
{
   if ( event.what==evBroadcast && event.message.command == cmListItemSelected )
   {
      event.what = evCommand;
      event.message.command = cmOK;
   }
   TDialog::handleEvent(event);
}

  //  if ( ( ctrlToArrow(event.keyDown.keyCode) ) == kbDown )

/*==========================================*/
TEnumValue::TEnumValue( const TRect& bounds, int aMaxLen ):
/*==========================================*/
   TInputLine(bounds,aMaxLen)
{
   if ( data!=NULL )
   {
      memset(data,' ',maxLen);       // Don't use setData 'cause of overriden dataSize
      data[maxLen]=0;
   }
   List = NULL; focusedItem=-1;
   TView::hideCursor();
}

/*================================*/
void TEnumValue::getData(void *rec)
/*================================*/
{
   *(ccIndex*)rec = focusedItem;
}
/*================================*/
void TEnumValue::setData(void *rec)
/*================================*/
{
  focusedItem = *(ccIndex*)rec;
  newFocusedItem(focusedItem);
}

/*-----------------------------------------*/
void strMaxLen ( char *s, int *maxlen)
/*-----------------------------------------*/
{
   if ( strlen(s) > *maxlen )
      *maxlen = strlen(s);
}

typedef void (*accAppFunc)(void*,void*);
/*------------------------------*/
void TEnumValue::MakeSelection( )
/*------------------------------*/
{
   struct { TCollection *items;
            ccIndex      focused; }
          BoxAnswer;
   if ( List == NULL ) return;
   int h = List->size();
   int w = 0;
   List->forEach((accAppFunc)strMaxLen,&w);
   w +=6;
   h +=2;
   if ( h>owner->size.y-4 )
      h=owner->size.y-4;

   TRect R;
    R.a.x=owner->origin.x+origin.x;
    R.b.x=R.a.x+w;
    R.a.y=max(0,owner->origin.y+origin.y-h/2);
    R.b.y=R.a.y+h;
   TScrollBar *scrollBar = NULL;

    TDialogDbl *D = new TDialogDbl(R, "..." );
    R.a.x=2; R.a.y=1; R.b.x=D->size.x-R.a.x; R.b.y=D->size.y-R.a.y;
   //if ( R.b.y-R.a.y<List->size() )
   //{
      scrollBar = new TScrollBar (TRect(R.b.x,R.a.y,R.b.x+1,R.b.y));
      D->insert(scrollBar);
   //}
    TListBox *Lbox = new TListBox(R, 1, scrollBar );
    if ( Lbox->size.y>=List->size() && scrollBar!=NULL )
    {
       scrollBar->setState(sfVisible,False);
    }

    //Lbox->newList(List);
    if ( focusedItem<0 || focusedItem>=List->size()) BoxAnswer.focused=0;
    else BoxAnswer.focused=focusedItem;
    //Lbox->focusItem(BoxAnswer.focused);
    TButton *B=new TButton( TRect(R.b.x/2-3,R.b.y+1,R.b.x/2+3,R.b.y+3),"O~K~", cmOK, bfDefault);
    B->setState(sfVisible,False);
    B->options &= !(ofSelectable);
    D->insert(B);

    BoxAnswer.items=List; /* ???????????????????????????????????? */
	 Lbox->setData(&BoxAnswer);
    D->insert(Lbox);

    // D = TProgram::application->deskTop->validView(D);
    if (D != NULL)
	{
	   if (TProgram::application->execView(D) == cmOK)
	   {
	      Lbox->getData(&BoxAnswer);
         newFocusedItem( BoxAnswer.focused );
	   }
	   destroy( D );
	}
}


/*=============================================*/
void  TEnumValue::newFocusedItem( ccIndex newItem )
/*=============================================*/
{
   if ( List!=NULL )
      if ( newItem>=0 && newItem<List->size() )
      {
         const char *t = (const char*)(List->at(newItem));
         if ( t != NULL )
         {  int l=strlen(t);
            if (l>maxLen) l=maxLen;
            memcpy(data,t,l);       // Don't use setData 'cause of override dataSize
            if (maxLen>l) memset(data+l,' ',maxLen-l);
            data[maxLen]=0;
            focusedItem = newItem;
            drawView();
            return;
         }
      }
}

/*===========================================*/
void  TEnumValue::handleEvent( TEvent& event )
/*===========================================*/
{
    TView::handleEvent(event);

    // if( (state & sfSelected) != 0 )

    switch ( event.what )
    {
       case evCommand:
           if ( event.message.command==cmEnumChange )
           {
              clearEvent( event );
              MakeSelection();
           }
           break;
       case evKeyDown:
           if ( event.keyDown.keyCode==kbEnter || event.keyDown.keyCode==kbDown )
           {
              clearEvent( event );
              MakeSelection();
           }
           break;
       case evMouseDown:
           if( event.mouse.doubleClick )
           {
              clearEvent( event );
              MakeSelection();
           }
           break;
    }
}


/*=============================================*/
void TEnumValue::newList ( TCollection2 *aList, ccIndex focusedNo )
/*=============================================*/
{
   if (List!=NULL) destroy(List);
   List = aList;
   focusedItem = -1;
   newFocusedItem(focusedNo);
   drawView();
}


/*=====================================*/
TPalette& TEnumArrow::getPalette() const
/*=====================================*/
{  static TPalette cp("\x0C",1);
   // cp[0]=TPalette::cpButton[0];
   return cp;
}


/*===================================================================*/
TEnumArrow::TEnumArrow( const TRect& bounds, const char *aTitle,
                        TView *aLink ):
/*===================================================================*/
   TStaticText(bounds,aTitle)
{
   Link=aLink;
   options &= !ofSelectable;
   setState(sfShadow,False);
}

/*=====================*/
void TEnumArrow::handleEvent(TEvent& event)
/*=====================*/
{
    if ( event.what==evMouseDown )
    {
       clearEvent(event);
       if ( Link!=NULL)
          message( Link, evCommand, cmEnumChange, this );
    }
}
