		ideal

struc		mcb
signature	db	?
addressPSP	dw	?
blockSize	dw	?
reserved	db	3 dup (?)
programName	db	8 dup (?)
ends		mcb

segment		newBlockSeg at 0
newBlock	mcb ?
ends		newBlockSeg

segment		oldBlockSeg at 0
oldBlock	mcb ?
ends		oldBlockSeg

;		DOS calls
getPSP		equ	62h

;		values for signature
notLastInChain	equ	'M'
LastInChain	equ	'Z'

;		values for addressPSP
freeMemory	equ	0
allocatedPreDOS	equ	8

segment		memoryMangler
		assume cs:memoryMangler,ds:oldBlockSeg,es:newBlockSeg

;	IN:	dx == amount of memory to request
;	OUT:	dx == segment of new block of memory
;	OUT:	dx == 0 on error
proc		hackMem far
		push	ax
		push	bx
		push	cx
		push	ds
		push	es

		mov	ah,getPSP
		int 	21h
		dec	bx	;bx:0000 points to the MCB of the program
		mov	ds,bx	;ds:0000 points to the MCB of the program

		mov	cx,[oldBlock.blockSize]
		cmp	cx,1
		jbe	error
		dec	cx
		sub	cx,dx	;cx is the new size of the program's main
				;memory block
		jbe	error
		mov	[oldBlock.blockSize],cx

		inc	bx
		add	bx,cx	;bx:0000 points to the MCB of the new block
		mov	es,bx

		mov	al,[oldBlock.signature]	;see if this is the last
						;block in the chain
		mov	[newBlock.signature],al
		mov	[oldBlock.signature],notLastInChain	;We are
						;certainly no longer the
						;last in the chain

		mov	[newBlock.addressPSP],es
				;we don't want to get rid of this block ever

		mov	[newBlock.blockSize],dx
				;set the block size as requested

		mov	si,offset oldBlock.reserved	;copy the standard info
		mov	di,offset newBlock.reserved	;into the new mcb
		mov	cx,11
	rep	movs	[newBlock.reserved],[oldBlock.reserved]

		mov	dx,es
		inc	dx
		jmp	done

error:		mov	dx,0

done:		pop	es
		pop	ds
		pop	cx
		pop	bx
		pop	ax
		ret
endp		hackMem

ends		memoryMangler

		public hackMem

		end

