
// Copyright 1992, David Perelman-Hall & Jamshid Afshar

#include <assert.h>
#include "category.h"


ostream& operator << ( ostream& os, const Category& cat )
{
   os << cat._s;
   return os;
}

//destructor
Category::~Category()
{
   if (alive == DEAD)
      abort();
   if (alive != ALIVE)
      abort();
   alive = DEAD;
}


Category_Sequence::Category_Sequence()
   : _first_node(NULL) { alive = ALIVE; }
 
Category_Sequence::Category_Sequence( const Category_Sequence& seq)
   : _first_node(NULL)
{
   alive = ALIVE;
   *this = seq;
}

Category_Sequence::Category_Sequence( const Category& category )
   : _first_node(NULL) 
{ 
   alive = ALIVE; 
   *this += category;
}

Category_Sequence::~Category_Sequence()
{
   assert(alive==ALIVE);
   alive = DEAD;
   clear();
}

Category Category_Sequence::pop()
{
   assert(!isEmpty());
   Category cat = _first_node->_category;
   CategoryNode *temp = _first_node;
   _first_node = _first_node->_nextp;
   delete temp;
   return cat;
}

//operator =
void Category_Sequence::operator = ( const Category_Sequence& seq)
{
   clear();

   const CategoryNode *catnp = seq._first_node;
   CategoryNode **thiscatnpp = &_first_node;
   while ( catnp != NULL ){
      *thiscatnpp = new CategoryNode(catnp->_category, NULL);
      thiscatnpp = &((*thiscatnpp)->_nextp);
      catnp = catnp->_nextp;
   }
}

//operator +=
Category_Sequence& Category_Sequence::operator += ( const Category& category)
{
   assert(strcmp(category, "") != 0);
   CategoryNode **thiscatnpp = &_first_node;
   while( *thiscatnpp != 0 )
      thiscatnpp = &((*thiscatnpp)->_nextp);
   *thiscatnpp = new CategoryNode(category, NULL);
   return *this;
}

//operator +=
Category_Sequence& Category_Sequence::operator += ( const Category_Sequence& seq)
{
   const CategoryNode *catnp = seq._first_node;
   while ( catnp != NULL ){
      *this += catnp->_category;
      catnp = catnp->_nextp;
   }
   return *this;
}

void Category_Sequence::clear()
{
   while ( !isEmpty() )
      pop();
}

Category_Sequence Category_Sequence::rest() const
{
   Category_Sequence seq = *this;
   seq.pop();
   return seq;
}

int Category_Sequence::length() const
{
   int n = 0;
   const CategoryNode *catnp = _first_node;
   while ( catnp != NULL ){
      n += 1;
      catnp = catnp->_nextp;
   }
   return n;
}

bool Category_Sequence::operator == ( const Category_Sequence& seq) const
{
   CategoryNode *s1 = _first_node;
   CategoryNode *s2 = seq._first_node;
   while ( s1 != NULL && s2 != NULL ) {
      if ( s1->_category != s2->_category )
         return FALSE;
      s1 = s1->_nextp;
      s2 = s2->_nextp;
      }
   return s1==NULL && s2==NULL;
}

ostream& operator << ( ostream& os, const Category_Sequence& seq )
{
   const CategoryNode *catnp = seq._first_node;
   bool is_first = TRUE;
   while ( catnp != NULL ){
      if (!is_first)
         os << " ";
      os << catnp->_category;
      catnp = catnp->_nextp;
      is_first = FALSE;
   }
   return os;
}

istream& operator >> ( istream& is, Category_Sequence& seq )
{
   seq.clear();
   char cat_str[MAX_STRING_LEN];
   while (is.good()) {
      is >> cat_str;
      if (is.fail()) break;
      seq += Category(cat_str);
   }
   return is;
}
