/* Fill prefix commands for Epsilon.

   (c) Copyright 1990 Carl W. Hoffman.  All rights reserved.

   This file may be freely copied, distributed, or modified for non-commercial
   use provided that this copyright notice is not removed.  For further
   information about other Common Lisp and Scheme utilities, contact the
   following address:

   Carl W. Hoffman, 363 Marlborough Street, Boston, MA 02115, U.S.A.
   Internet: CWH@AI.MIT.EDU    CompuServe: 76416,3365    Fax: 617-262-4284

   This code has been tested with Epsilon version 4.13. */

#include <eel.h>

buffer char fill_prefix[60];

when_loading()
{
  strcpy(fill_prefix, "");
  strcpy(fill_prefix.default, "");
  }

/* To be compatible with standard implementations of fill prefix, only when
the fill prefix is empty should forward_paragraph and backward_paragraph be
used to determine the paragraph to be filled.  If a fill prefix is defined,
the paragraph is defined to be a contiguous group of lines having the same
fill prefix.  The forward_paragraph and backward_paragraph commands should
observe this convention, also. */

#define at_beginning_of_line(pos) \
  (((pos) == 0) || (character((pos)-1) == '\n'))

command fill_paragraph() on reg_tab[ALT('q')]
{
  int end, start=point;
  int prefix_length = strlen(fill_prefix);

  iter = 0;
  forward_paragraph();
  end = point - 1;
  backward_paragraph(); 
  if (!prefix_length) {
    /* Leave leading whitespace intact */
    re_search(1, "[ \t\n]*");
    region_fill(point, end);
    }
  else {

    int prefix_seen = 0;
    int fill_start = point;
    int *fill_end = alloc_spot();
    *fill_end = end;

    /* Remove existing fill prefixes, if any exist. */

    while (search(1, fill_prefix)) {
      if (!(point < *fill_end))
        break;
      if (at_beginning_of_line(matchstart)) {
        if (point < start)
          start -= prefix_length;
        else if (matchstart < start)
          start = matchstart;
        delete(matchstart, point);
        prefix_seen = 1;
        }
      }

    /* Fill the region.  Even though fill_end is a spot,
       it is left at the beginning of the last line of the
       filled region.  Therefore, move it to the end of the
       line before putting the fill prefixes back. */

    if (prefix_seen)
      margin_right -= prefix_length;
    region_fill(fill_start, *fill_end);
    point = *fill_end;
    to_end_line();
    *fill_end = point;

    /* If at least one fill prefix was removed from the region,
       then put them back on every line in the region. */

    if (prefix_seen) {
      margin_right += prefix_length;
      point = fill_start;
      while (point < *fill_end) {
        if (point < start)
          start += prefix_length;
        stuff(fill_prefix);
        nl_forward();
        }
      }
    free_spot(fill_end);
    }

  if (start > size()) start = size();
  point = start;
  }

command set_fill_prefix() on cx_tab['.']
{
  int start=point;
  to_begin_line();
  grab(point, start, fill_prefix);
  say("Fill prefix set to %s", fill_prefix);
  }

suffix_bat() { bat_mode(); }

command bat_mode ()
{
  margin_right = 79;
  fill_mode = 0;
  strcpy(fill_prefix, "rem ");
  major_mode = "DOS Batch";
  make_mode();
  }

suffix_asp() { asp_mode(); }

command asp_mode ()
{
  margin_right = 79;
  fill_mode = 0;
  strcpy(fill_prefix, ";; ");
  major_mode = "Procomm Plus ASP";
  make_mode();
  }

/* One of c_mode or make_mode must be called at the end of this command.
   Otherwise, the mode line will be incorrect. */

command ansi_c_mode()
{
  margin_right = 79;
  fill_mode = 0;
  strcpy(fill_prefix, "// ");
  c_mode();
  }

suffix_c()   { ansi_c_mode(); }
suffix_h()   { ansi_c_mode(); }
suffix_e()   { ansi_c_mode(); }
suffix_pre() { ansi_c_mode(); }
suffix_rc()  { ansi_c_mode(); }
suffix_y()   { ansi_c_mode(); }
