/* dstring.c - The dynamic string handling routines used by cpio.
   Copyright (C) 1988, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* MS-DOS port (c) 1990 by Thorsten Ohl, ohl@gnu.ai.mit.edu
   This port is also distributed under the terms of the
   GNU General Public License as published by the
   Free Software Foundation.

   Please note that this file is not identical to the
   original GNU release, you should have received this
   code as patch to the official release.

   $Header: e:/gnu/cpio/RCS/dstring.c 1.1.0.2 90/09/23 23:11:06 tho Exp $
 */

#include <stdio.h>
#ifdef USG
#include <string.h>
#else
#include <strings.h>
#endif
#include "dstring.h"

#ifdef MSDOS
extern char *xmalloc (unsigned int size);
extern char *xrealloc (char *ptr, unsigned int size);
#else /* not MSDOS */
char *xmalloc ();
char *xrealloc ();
#endif /* not MSDOS */

/* Initialiaze dynamic string STRING with space for SIZE characters.  */

void
ds_init (string, size)
     dynamic_string *string;
     int size;
{
  string->ds_length = size;
  string->ds_string = (char *) xmalloc (size);
}

/* Expand dynamic string STRING, if necessary, to hold SIZE characters.  */

void
ds_resize (string, size)
     dynamic_string *string;
     int size;
{
  if (size > string->ds_length)
    {
      string->ds_length = size;
      string->ds_string = (char *) xrealloc ((char *) string->ds_string, size);
    }
}

/* Dynamic string S gets a string from file F.  S will increase
   in size during the function if the string from F is longer than
   the current size of S.
   Return NULL if end of file is detected.  Otherwise,
   Return a pointer to the null-terminated string in S.  */

char *
ds_fgets (f, s)
     FILE *f;
     dynamic_string *s;
{
  int insize;			/* Amount needed for line. */
  int strsize;			/* Amount allocated for S. */
  int next_ch;

  /* Initialize.  */
  insize = 0;
  strsize = s->ds_length;

  /* Read the input string.  */
  next_ch = getc (f);
  while (next_ch != '\n' && next_ch != EOF)
    {
      if (insize >= strsize - 1)
	{
	  ds_resize (s, strsize * 2 + 2);
	  strsize = s->ds_length;
	}
      s->ds_string[insize++] = next_ch;
      next_ch = getc (f);
    }
  s->ds_string[insize++] = '\0';

  if (insize == 1 && next_ch == EOF)
    return NULL;
  else
    return s->ds_string;
}
