Serial synthesizers and Jaws

A serial synthesizer is one that connects to one of the serial
ports on your personal computer.  This includes the Braille 'n
Speak, Accent SA, Audaptor, Dectalk, Kurzweil Dectalk, and others.

The serial ports on the back of the computer are also called COM
ports, usually referred to as COM1, COM2, COM3, etc.  These are
"male" ports, as opposed to "female" ports.  This refers to the
fact that they have pins instead of sockets.  Because these ports
have pins they have a rough surface, while the female ports have a
smooth surface.  This is how you tell them apart by feel.  The
female ports are usually parallel ports, such as for printers. 
These are general descriptions, there could be other "ports" on the
back of your computer that feel rough but are not necessarily
serial ports.

The synthesizer must be connected to the computer by a serial
cable.  There is no "standard" serial cable.  These are sometimes
referred to as "RS-232", which specifies what wires might be inside
the cable.  Besides needing the wires and connections inside the
cable you need to be sure that each end of the cable is the correct
gender, male or female, to connect to the synthesizer or computer. 
Here are some tips:

Accent SA:  straight-through modem cable, male/female;
Kurzweil Personal Reader:  straight through modem cable,
male/female;
Dectalk:  null modem cable, female/female;
The serial ports also come in 2 different sizes, DB25 and DB9,
which refers to the number of pins or separate connections.  Some
computers have the COM ports situated horizontally, in which case
there are 2 rows of pins, with 12 pins in one row and 13 pins in
the other.  If the port is situated vertically then there are 2
columns, with 12 or 13 pins in each column.  Naturally if it is a
9-pin port then each row/column has 4 or 5 pins.  One side of the
port is longer than the other, it is trapezoidal in shape, and
therefore the cable can only go on one way.  When you are
connecting a cable, if it does not go on one way then flip it over. 
Naturally this is assuming that you have the sexes right, female on
the cable connecting to male on the PC.

We can usually figure out which are the serial ports and get the
synthesizer physically connected.  But if there are more than one
it is difficult to determine which is COM1, which is COM2, etc. 
Some computers have them labeled in print or pictures, which is
fine if you can see.  Generally speaking there is no way to tell
which is which unless they are labeled or you have specific
documentation.  If you are in doubt refer to your computer manual. 
If this is not practical then just go ahead and try it.  If that
doesn't work then try the other one.

It is important that we know or can figure out which one we are
connecting to, since Jaws must be told if you want it to use any
COM port other than COM1.  Jaws will automatically assume you want
to use COM1, so if you connect the synthesizer to COM1 then you do
not have to tell Jaws.  But if you want to use COM2, COM3, or
others you must tell Jaws with a command line parameter.  Refer to
the installation instructions for your particular synthesizer and
Jaws version for details.


What if it does not work?

So you know all the things mentioned above, you have connected your
synthesizer and tried to boot up Jaws, but it isn't working.  If
the Jaws logo appears on the screen but no sound comes out or it is
garbled go through the following check list, and please do not
think that we are insulting your intelligence.  If the Jaws logo
does not appear on the screen then you have a different problem,
refer to the section titled "Loading Jaws".

1.  Is it turned on?  Be sure it is plugged in or the batteries are
installed.  Most serial synthesizers will say something when you
turn them on.
2.  Maybe it is on but you cannot hear it.  Does it need a speaker
or headphones connected, like the portable Dectalk?  Maybe the
headphones are installed but you do not have them on?  Maybe they
are plugged into the wrong socket?  If you plug a mono speaker into
a stereo jack you may not be able to hear it.  Remember step one,
it should say something when you turn it on.

3.  Are you using the right cable?  If we provided the cable with
the synthesizer then chances are good but not 100%, everybody makes
some mistakes.  If your buddy or supervisor provided the cable then
be highly suspect.  There is no standard RS-232 serial cable, they
can be and usually are very different.  Contact us if you need to
buy the correct cable.

4.  Is the cable firmly connected at each end?  Be sure it is
plugged in all the way and then secured with the little screws on
each side of the connector.  Do not force it or over tighten it,
but be firm.

5.  Is it connected to the correct COM port?  Maybe it isn't
connected to a COM port at all.  Use the "DOS test" explained below
to be sure you know which port it is connected to and that the port
is working.

6.  Maybe the synthesizer is set to the wrong BAUD rate.  This is
also known as the data transfer rate, or bits per second.  If the
synthesizer is speaking garbage then it is likely a rate problem. 
Refer to the synthesizer manual or our installation instructions to
set it correctly.  It could also be a parity problem, or data bits
or stop bits.  Refer to the specific installation instructions for
your version of jaws and be sure the synthesizer is set
accordingly.


The "DOS" test

To confirm that the synthesizer is working, the cable is correct
and connected, and that the COM port is working we need to use DOS
to output some information to the synthesizer.  If DOS can send
data to the synthesizer and make it talk, but Jaws cannot, then we
have one of the conflicts discussed below.  Follow these steps for
the DOS test

Set the BAUD rate, parity, data bits, and stop bits with the
"MODE.COM" program.  Lets assume your synthesizer is running at
9600 BAUD, even parity, 7 data bits, 1 stop bit.  This is very
common, and will work for the Accent SA, most DecTalks and KPR's,
and the Braille 'n Speak.  Enter the following at the DOS prompt:

MODE COM1:9600,E,7,1

If you are using COM2 then make the appropriate substitution.  If
your synthesizer is using different parameters (BAUD rate, parity,
etc.) make the appropriate substitutions.  If you get the message
"Bad command or file name" then DOS could not find the "MODE"
program.  Be sure it is on your disk and give DOS a "path" to it by
preceding the file name with the subdirectory name, e.g.:

\DOS\MODE COM2:9600,E,7,1

When the command is completed successfully it will put a message on
the screen, repeating the parameters.  If you get this far
successfully then tell DOS to send some data out the correct COM
port to the synthesizer, enter the following:

DIR/W >COM1

If you want COM2 then change the 1 to a 2.  This command will cause
DOS to send all the file names out the COM port and hopefully to
the synthesizer.  At this point the synthesizer should start
talking.  If it does then proceed to the section on "Conflicts" to
get Jaws working.  If it does not start to talk then you have a
more fundamental problem, hinted at in items 1-6 above.  It is
always possible that the synthesizer is broken, review the
suggestions above and the DOS test to be sure you have tried
everything to get it to work.


Serial port conflicts

Now we get down to the heart of the matter.  The most common
problem with serial synthesizers is conflicts with other serial
devices installed in the computer.  Besides COM ports you may have
an internal modem, mouse port, or some other device that uses the
same IRQ or Interrupt Request line.  The COM ports use IRQ 3 or 4.

If there is a conflict, if another device is using the same IRQ
that the synthesizer/com port is using then you will notice some
problems:  the data may not get spoken at all, it may speak a
little then pause, it may lock up completely, and perhaps other
symptoms.  It is very unpredictable.  If you notice strange things
like this happening you need to take steps to correct it.

The most obvious solution is to use the other COM port.  Connect
the cable to one of the other COM ports, re-load Jaws with the
correct parameters and see if it works.  See the documentation on
your specific synthesizer for the proper command line parameters. 

If you cannot do that then you must take steps to resolve the
conflict. The most obvious way to do this is to remove any other
device that may be causing the conflict.  The term "device" refers
to another circuit board, like an internal modem or another serial
port.

If you have an internal modem in your PC then remove it.  If you
have an extra serial port circuit board installed then remove it. 
If you have an internal synthesizer installed, like a Sounding
Board or a Symphonics board then remove it.  This is not a
permanent solution, just steps along the way to discovering what is
causing the problem.  We must identify the culprit before we can
devise a remedy.  Once the other devices are removed and Jaws
starts to work properly then we know what is causing the conflict. 
There is a lot of trial and error involved, just keep trying things
until you find something that works.  This description is very
general by necessity.  Each computer with its devices is a unique
environment with a unique solution.

If Jaws and other screen readers seem to work fine, but the "Say
All" feature of Jaws does not work then you can be sure there is an
IRQ conflict.  Most screen readers just send data out and do not
expect any data back from the synthesizer.  Most of Jaws' features
work this way also.  However the "Say All" feature depends on
getting back "index markers" which allow Jaws to stop on the last
word spoken.  This is a feature and capability that most other
screen readers do not have.

Changing the COM port number

If you have fixed the problem by removing the offending device you
may want to put it back in the computer.  To prevent causing the
same problem again you should try changing the COM number.  You may
change it to COM3 or COM4 or higher.  Refer to the specific
instructions for the particular device in its manual to see how to
do this.

Changing the IRQ

You may find that you cannot change the COM number, then try
changing the IRQ.  Refer to the manual of the offending device to
see how to do this.  If it is a serial device like a modem then you
are pretty well limited to IRQ 3 or 4.  If it is an internal
synthesizer you can probably use IRQ 2 or 7.  For other devices the
manual may have some suggestions.  There may not be a solution, you
may just have to decide which is more important and go with it.

Changing the base address

A base address or I/O address conflict is less likely, but it does
happen.  This is different than an IRQ conflict but just as
debilitating, maybe even more so.  In this case you will probably
get no speech at all, it won't say a thing.  Again you must look at
your unique situation and decide which devices may be causing the
problem and remove them.  Then refer to the manual of the offending
device to see how to change its base address.  The manual will
probably have some suggestions as to which ones to use.  Any time
you change this you run the risk of conflicting with some other
device installed in the computer, so be aware.  You may solve the
synthesizer problem only to discover that your network no longer
works.
