/*-
 * TTY service routines.  (tty.c)
 *
 * Mutex in UNIX
 *
 * Bryan So, September 29, 1990
 */

#include "tty.h"


static struct sgttyb mode;  	/* Temporary variable for most funcs */

/*
 * Changing tty line discipline for a tty descriptor.
 */
int tty_raw(fd)
int fd;
{
     if (ioctl(fd, TIOCGETP, (char *)&mode) < 0)
	  return -1;
     mode.sg_flags |= RAW;

     return ioctl(fd, TIOCSETP, (char *)&mode);
}


int tty_cbreak(fd)
int fd;
{
     if (ioctl(fd, TIOCGETP, (char *)&mode) < 0)
	  return -1;
     mode.sg_flags |= CBREAK;

     return ioctl(fd, TIOCSETP, (char *)&mode);
}


int tty_echo(fd)
int fd;
{
     if (ioctl(fd, TIOCGETP, (char *)&mode) < 0)
	  return -1;
     mode.sg_flags |= ECHO;

     return ioctl(fd, TIOCSETP, (char *)&mode);
}


int tty_noraw(fd)
int fd;
{
     if (ioctl(fd, TIOCGETP, (char *)&mode) < 0)
	  return -1;
     mode.sg_flags &= ~RAW;

     return ioctl(fd, TIOCSETP, (char *)&mode);
}


int tty_nocbreak(fd)
int fd;
{
     if (ioctl(fd, TIOCGETP, (char *)&mode) < 0)
	  return -1;
     mode.sg_flags &= ~CBREAK;

     return ioctl(fd, TIOCSETP, (char *)&mode);
}


int tty_noecho(fd)
int fd;
{
     if (ioctl(fd, TIOCGETP, (char *)&mode) < 0)
	  return -1;
     mode.sg_flags &= ~ECHO;

     return ioctl(fd, TIOCSETP, (char *)&mode);
}


/*
 * Some shorthands to be used by the following functions.
 */

#define Sgttyb (tty->tty_sgttyb)
#define Tchars (tty->tty_tchars)
#define Ltchars (tty->tty_ltchars)
#define Winsize (tty->tty_winsize)
#define Lmode (tty->tty_lmode)
#define Ldisc (tty->tty_ldisc)


/*
 * Get the terminal modes from a descriptor.
 */
int tty_get_mode(tty, fd)
Tty *tty;
int fd;
{
     if (ioctl(fd, TIOCGETP, (char *)&Sgttyb) < 0) return -1;
     if (ioctl(fd, TIOCGETC, (char *)&Tchars) < 0) return -1;
     if (ioctl(fd, TIOCGLTC, (char *)&Ltchars) < 0) return -1;
     if (ioctl(fd, TIOCGWINSZ, (char *)&Winsize) < 0) return -1;
     if (ioctl(fd, TIOCLGET, (char *)&Lmode) < 0) return -1;
     return ioctl(fd, TIOCGETD, (char *)&Ldisc);
}


/*
 * Set the terminal modes for a descriptor.
 */
int tty_set_mode(tty, fd)
Tty *tty;
int fd;
{
     if (ioctl(fd, TIOCSETP, (char *)&Sgttyb) < 0) return -1;
     if (ioctl(fd, TIOCSETC, (char *)&Tchars) < 0) return -1;
     if (ioctl(fd, TIOCSLTC, (char *)&Ltchars) < 0) return -1;
     if (ioctl(fd, TIOCSWINSZ, (char *)&Winsize) < 0) return -1;
     if (ioctl(fd, TIOCLSET, (char *)&Lmode) < 0) return -1;
     return ioctl(fd, TIOCSETD, (char *)&Ldisc);
}


/*
 * Done with the shorthands
 */

#undef Sgttyb 
#undef Tchars
#undef Ltchars 
#undef Winsize
#undef Lmode 
#undef Ldisc


/*
 * Copy a set of terminal modes to another descriptor
 */
int tty_copy(source, dest)
int source, dest;
{
     Tty tty;

     if (tty_get_mode(&tty, source) < 0) return -1;

     return tty_set_mode(&tty, dest);
}


#if 0

#include <stdio.h>
main()
{
     char s[80];

     tty_cbreak(0);
     tty_noecho(0);

     printf("Enter password: ");
     fflush(stdout);

     fgets(s, 79, stdin);
     printf("%s", s);

     tty_nocbreak(0);
     tty_echo(0);

     return 0;
}

#endif
