
{******************************************************************************
 *                                                                            *
 *         PC MAGAZINE'S INTERACTIVE READER OF THE BIOSDATA  REGION           *
 *               Copyright (c) 1990 Ziff Communications Co.                   *
 *                      written by Barry Simon                                *
 *                                                                            *
 *****************************************************************************}

USES CRT, DOS;

CONST
  HexDigits : ARRAY[0..15] OF Char = '0123456789ABCDEF';

  FUNCTION ByteToHex(B : Byte) : STRING;
    {Changes byte to hex string}
  BEGIN
    ByteToHex := HexDigits[B DIV 16]+HexDigits[B MOD 16];
  END;

TYPE
  ByteLine = ARRAY[0..15] OF Byte; {display as one line}
  BytePage = ARRAY[0..15] OF ByteLine; {display ful 256 bytes}

VAR
  BiosArea : BytePage ABSOLUTE $0000 : $0400;
  {by allowing type usage, this is better then using the Mem array}
  CurH, CurL : Byte;
  Regs : Registers;

  PROCEDURE HideCursor;
  BEGIN
    WITH Regs DO BEGIN
      AH := 3;                    {read cursor info}
      BH := 0;                    {assume page 0}
      intr($10, Regs);
      CurH := CH; CurL := CL;     {save cursor info}
      AH := 1;                    {set Cursor Shape}
      CX := $2000;                {hide cursor}
      intr($10, Regs);
    END;
  END;

  PROCEDURE RestoreCursor;
  BEGIN
    WITH Regs DO BEGIN
      CH := CurH; CL := CurL;     {restore cursor info}
      AH := 1;                    {set Cursor Shape}
      intr($10, Regs);
    END;
  END;

  FUNCTION ShowByteLine(B : ByteLine; j : Integer) : STRING;
  CONST
    specialchars : SET OF Byte = [7, 8, 10, 13];
    {needed because Turbo displays these characters as screen actions}
  VAR
    i : Byte;
    s : STRING;
  BEGIN
    s := '0040:00'+Char($30+j+7*(j DIV 10))+'0  ';
        {the $30+n is ASCII for n for n=0,..,9.  The 7*(j div 10) adjusts
          for 10 to become A,...,15 to become F}
    FOR i := 0 TO 15 DO BEGIN
      s := s+ByteToHex(B[i])+' ';
      {IF ((i MOD 4) = 3) THEN s := s+' ';}
    END;
    s := s+'';
    FOR i := 0 TO 15 DO IF (B[i] IN specialchars) THEN
      s := s+' '
      ELSE s := s+Char(B[i]);
    ShowByteLine := s;
  END;

  FUNCTION EscHit : Boolean;
  VAR
    R : Registers;
  BEGIN
    WITH R DO BEGIN
      {use service 0 of int 16 to check for Escape}
      AH := 00;
      intr($16, R);
      IF AL = 27 {escape} THEN EscHit := True ELSE EscHit := False;
    END;
  END;

VAR
  j : Byte;
  C : ByteLine;

BEGIN
  textattr := $0F;
  HideCursor;
  Clrscr;
  gotoXY(1, 2);
  WriteLn('');
  WriteLn('                 PC Magazine''s Interactive BIOS DATA AREA Reader               ');
  WriteLn('                   Copyright (c) 1990 Ziff Communications Co.                 ');
  WriteLn('');
  gotoXY(1, 22);
  WriteLn('');
  WriteLn('                                Hit <Esc> to Exit');
  WHILE True DO BEGIN
    gotoXY(1, 6);
    FOR j := 0 TO 15 DO WriteLn(ShowByteLine(BiosArea[j], j));
    IF keypressed THEN
      IF EscHit THEN BEGIN RestoreCursor; gotoXY(80, 24); Halt; END;
  END;
END.
