/*------------------------------------------
   WHATCLR.C -- Displays Color Under Cursor
                (c) Charles Petzold, 1990
  ------------------------------------------*/

#include <windows.h>
#define ID_TIMER    1

void            FindWindowSize (short *, short *) ;
long FAR PASCAL WndProc (HWND, WORD, WORD, LONG) ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     static char szAppName[] = "WhatClr" ;
     HWND        hwnd ;
     MSG         msg ;
     short       cxClient, cyClient ;
     WNDCLASS    wndclass ;

     if (!hPrevInstance) 
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     FindWindowSize (&cxClient, &cyClient) ;

     hwnd = CreateWindow (szAppName, "What Color",
                          WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_BORDER,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          cxClient, cyClient,
                          NULL, NULL, hInstance, NULL) ;

     while (!SetTimer (hwnd, ID_TIMER, 100, NULL))
          if (IDCANCEL == MessageBox (hwnd,
                              "Too many clocks or timers!", szAppName,
                              MB_ICONEXCLAMATION | MB_RETRYCANCEL))
               return FALSE ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }

     KillTimer (hwnd, ID_TIMER) ;

     return msg.wParam ;
     }

void FindWindowSize (short * pcxClient, short * pcyClient)
     {
     DWORD      dwExtent ;
     HDC        hdc ;
     TEXTMETRIC tm ;

     hdc = CreateIC ("DISPLAY", NULL, NULL, NULL) ;
     dwExtent = GetTextExtent (hdc, "  FF FF FF  ", 12) ;
     DeleteDC (hdc) ;

     * pcxClient = 2 * GetSystemMetrics (SM_CXBORDER)  + LOWORD (dwExtent) ;
     * pcyClient = 2 * GetSystemMetrics (SM_CYBORDER)  +
                       GetSystemMetrics (SM_CYCAPTION) + 2 * HIWORD (dwExtent) ;
     }

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
     {
     static char     chBuffer [16] ;
     static COLORREF crPixel ;
     HDC             hdc ;
     COLORREF        cr ;
     PAINTSTRUCT     ps ;
     POINT           pt ;
     RECT            rc ;

     switch (message)
          {
          case WM_TIMER:
               hdc = CreateDC ("DISPLAY", NULL, NULL, NULL) ;

               GetCursorPos (&pt) ;
               cr = GetPixel (hdc, pt.x, pt.y) ;

               if (cr != crPixel)
                    {
                    crPixel = cr ;
                    InvalidateRect (hwnd, NULL, FALSE) ;
                    }

               DeleteDC (hdc) ;
               return 0 ;

          case WM_PAINT:
               hdc = BeginPaint (hwnd, &ps) ;

               GetClientRect (hwnd, &rc) ;

               wsprintf (chBuffer, "  %02X %02X %02X  ",
                         GetRValue (crPixel), GetGValue (crPixel),
                         GetBValue (crPixel)) ;

               DrawText (hdc, chBuffer, -1, &rc,
                         DT_SINGLELINE | DT_CENTER | DT_VCENTER) ;

               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY:
               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
