/* RAT.C
   RAT.BIN source, compile/link with:
   TCC -mc -c rat                 : memory model MUST BE compact,
   TLINK /i rat,,,D:\TC\LIB\CC    : data is far, use dBIV's stack
                                  : assuming CC.LIB is in D:\TC\LIB\
   EXE2BIN rat                    : creates RAT.BIN
   DEL rat.obj
   DEL rat.exe

   to use from dBASE IV only(!):
   .LOAD rat
   .srchstr="the quick sly fox jumped over the..."
   .position=CALL("rat",0,srchstr,"the")
   * now position = 31
   * All parameters can be fields, expressions, memvars, or literals.
   * The numeric parameter MUST be numeric and the last two MUST be
   * strings.
*/

#include <dos.h>
#include <string.h>
#include <stdlib.h>

short rat(char *s,char *f);

void far main(void)
{
   char **argv;
   short retval;
 
   if (_CX != 3)                            /* If there aren't three */
      return;                                  /* parameters, return */

   argv = (char **) MK_FP(_ES, _DI);     /* point to dBASE parameter */
                                                   /* table in ES:DI */
   retval = rat(argv[1],argv[2]);

   itoa(retval,argv[0],10);            /* convert number to a string */
   return;                                          /* back to dBASE */
}

short rat(char *srchstr, char *findstr)
{
   char *mark;
   char *astring = srchstr;

   if (*srchstr == 0 || *findstr == 0)   /* If one of them isn't set */
      return(0);                                         /* return 0 */

   mark = strstr(astring, findstr);         /* Call library function */

   if (mark == NULL)                         /* If not found, return */
      return(0);

   astring++;                             /* Bump past that position */

   while (mark != NULL)                /* While we keep finding them */
   {
      astring = mark;
      mark = strstr(astring + 1, findstr);      /* Keep finding them */
   }
                                      /* Return position of last one */
   return(astring - srchstr + 1);
}
