
 //  WinFSR BETA  by Fran Finnegan (76244,145)
 //  Copyright (c) 1991 Finnegan O'Malley & Company Inc.
 //              All Rights Reserved.
 //  First Published in PC Magazine, November 12, 1991.

 #define NOCOMM
 #include <windows.h>

 extern DWORD FAR PASCAL GetHeapSpaces(HANDLE hModule);

 ///////////////////////////////////////////////////////////////////

 extern int       PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
 extern long  FAR PASCAL WndProc(HWND, WORD, WORD, DWORD);
 extern int   FAR PASCAL DlgProc(HWND, WORD, WORD, DWORD);

 #define FALSE           0
 #define TRUE            1

 #define ID_TIMER        1

 static  WNDCLASS        mWc;
 static  HWND            mhDlg;
 static  char            mszName[] = "WINFSR";

 ///////////////////////////////////////////////////////////////////

 extern int       PASCAL WinMain(HANDLE ahInst, HANDLE ahPrevInst,
                                 LPSTR alpsCmdLine, int aiCmdShow)
 {
 auto    FARPROC         aFpDlgProc;
 auto    MSG             aMsg;

 static  HWND            shWnd;

 //  show any previous instance's dialog
 if (ahPrevInst)
     {
     GetInstanceData(ahPrevInst, (NPSTR)&shWnd, sizeof(shWnd));
     PostMessage(shWnd, WM_QUERYOPEN, 0, 0L);
     return FALSE;
     }

 //  register the window class
 mWc.lpfnWndProc   = WndProc;
 mWc.hInstance     = ahInst;
 mWc.hIcon         = LoadIcon(ahInst, mszName);
 mWc.lpszClassName = mszName;
 RegisterClass(&mWc);

 //  create and show the window as an icon
 shWnd = CreateWindow(mszName, "System Resources",
         WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, 0,
         CW_USEDEFAULT, CW_USEDEFAULT, 0, 0, ahInst, NULL);
 ShowWindow(shWnd, SW_SHOWMINIMIZED);

 //  create and show the dialog
 aFpDlgProc = MakeProcInstance(DlgProc, ahInst);
 mhDlg = CreateDialog(ahInst, "DIALOG", shWnd, aFpDlgProc);

 //  update the icon and dialog every second
 SetTimer(shWnd, ID_TIMER, 1000, NULL);

 while (GetMessage(&aMsg, 0, WM_NULL, WM_NULL))
     if (!(mhDlg && IsDialogMessage(mhDlg, &aMsg)))
         {
         TranslateMessage(&aMsg);
         DispatchMessage(&aMsg);
         }

 FreeProcInstance(aFpDlgProc);
 return FALSE;
 }

 ///////////////////////////////////////////////////////////////////

 extern long  FAR PASCAL WndProc(HWND ahWnd, WORD awMsg,
                                 WORD awParam, DWORD alParam)
 {
 auto    DWORD           adwGDI, adwUser;
 auto    WORD            awPctGDI, awPctUser, awPctFree;
 auto    HDC             ahDc;
 auto    int             aiSmCyIcon;
 auto    PAINTSTRUCT     aPs;
 auto    char            aszText[128];

 static  WORD            swPctFree = 9999, swWarningTrigger;
 static  BOOL            sbWarned;
 static  int             siNumColors;
 static  RECT            sRt;

 switch (awMsg)
     {
     case WM_CREATE:             //  WIN.INI default:  [WinFSR]
     case WM_WININICHANGE:       //                    %=20
         swWarningTrigger = GetProfileInt(mszName, "%", 20) * 100;
         break;

     case WM_SIZE:
         //  center the icon and text appropriately
         *(DWORD *)&sRt.left   = 0L;
         *(DWORD *)&sRt.right  = alParam;  //  same as GetClientRect
         aiSmCyIcon = GetSystemMetrics(SM_CYICON);
         InflateRect(&sRt, -((sRt.right  -
                 GetSystemMetrics(SM_CXICON)) / 2 + 1),
                 -((sRt.bottom - aiSmCyIcon)  / 2 + 1));
         sRt.bottom = sRt.top  + aiSmCyIcon   / 2;
         break;

     case WM_TIMER:
         //  calculate the Free System Resources percentages
         adwGDI  = GetHeapSpaces(GetModuleHandle("GDI" ));
         adwUser = GetHeapSpaces(GetModuleHandle("USER"));

         awPctGDI  = (WORD)(10000L * LOWORD(adwGDI ) /
                                     HIWORD(adwGDI ));
         awPctUser = (WORD)(10000L * LOWORD(adwUser) /
                                     HIWORD(adwUser));

         if (swPctFree != (awPctFree = min(awPctGDI, awPctUser)))
             {
             wsprintf(aszText,
                     "Free System Resources... %u%%\r\n"
                     "GDI: %u/%u=%u%%    USER: %u/%u=%u%%",
                     (swPctFree = awPctFree) / 100, adwGDI,
                     awPctGDI / 100, adwUser, awPctUser / 100);
             SetDlgItemText(mhDlg, 2, aszText);
             if (swWarningTrigger < swPctFree)   //  high FSRs
                 sbWarned  = FALSE;
             else                                //  low FSRs
                 if (sbWarned == FALSE)
                     {
                     sbWarned  = TRUE ;  //  show the dialog
                     PostMessage(ahWnd, WM_QUERYOPEN, 0, 0L);
                     }
             InvalidateRect(ahWnd, &sRt, FALSE);
             }
         break;

     case WM_PAINTICON:
         if (ahDc = BeginPaint(ahWnd, &aPs))
             {
             DrawIcon(ahDc, sRt.left - 1, sRt.top - 1, mWc.hIcon);
             if (siNumColors == 0)
                 siNumColors  = GetDeviceCaps(ahDc, NUMCOLORS);
             if (siNumColors >= 8)       //  check for colors
                 SetBkMode(ahDc, TRANSPARENT);
             DrawText(ahDc,   aszText,   //  paint over icon
                     wsprintf(aszText, "%u%%", swPctFree / 100),
                     &sRt, DT_CENTER | DT_NOCLIP | DT_NOPREFIX);
             EndPaint(ahWnd, &aPs);
             }
         break;

     case WM_QUERYOPEN:
         ShowWindow(mhDlg, SW_SHOW);     //  show the dialog
         BringWindowToTop(mhDlg);
         break;

     case WM_CLOSE:
         KillTimer(ahWnd, ID_TIMER);
         DestroyWindow(mhDlg);
         mhDlg = 0;
         DestroyWindow(ahWnd);
         break;

     case WM_DESTROY:
         PostQuitMessage(FALSE);
         break;

     default:
         return DefWindowProc(ahWnd, awMsg, awParam, alParam);
     }
 return FALSE;
 }

 ///////////////////////////////////////////////////////////////////

 extern int   FAR PASCAL DlgProc(HWND ahDlg, WORD awMsg,
                                 WORD awParam, DWORD alParam)
 {
 auto    RECT            aRt;

 switch (awMsg)
     {
     case WM_INITDIALOG:
         //  center dialog box
         GetWindowRect(ahDlg, &aRt);
         OffsetRect(&aRt, -aRt.left  , -aRt.top   );
         MoveWindow(ahDlg,   //  correct way to center a dialog:
                 ((GetSystemMetrics(SM_CXSCREEN) - aRt.right ) / 2 +
                                                            4) & ~7,
                  (GetSystemMetrics(SM_CYSCREEN) - aRt.bottom) / 2,
                 aRt.right , aRt.bottom, FALSE);
         return TRUE;    //  did process the message

     case WM_COMMAND:
         ShowWindow(ahDlg, SW_HIDE);     //  hide the dialog
         return TRUE;    //  did process the message
     }
 return FALSE;   //  did not process the message
 }

