//
// SysMon.H -- Header File for SysMon.C
//

#if !defined(WIN32)

  #define WIN16     TRUE
  #define WIN31

  #define INT       int
  #define UINT      WORD
  #define APIENTRY  PASCAL
  #define WNDPROC   FARPROC
  #define THUMBPOS  LOWORD(lParam)

#else

  #define WIN16     FALSE
  #define THUMBPOS  HIWORD(wParam)

#endif

struct decodeMsg {                         	// structure associates
    UINT Code;                              // messages or menu IDs
    LONG (*Fxn)(HWND, UINT, UINT, LONG); }; // with a function

struct decodeUINT {                         // structure associates
    UINT Code;                              // UINTs with a string
    char * Name; };                         

// arbitrary menu identifiers
#define  IDM_OPEN     100
#define  IDM_EXIT     101
#define  IDM_ABOUT    102
#define  IDM_MODULE   103
#define  IDM_CLASS	  104
#define  IDM_TASK	  105
#define  IDM_GLOBHEAP 106
#define  IDM_SYSHEAP  107
#define  IDM_MEMMAN   108
#define  IDM_DISK     109
#define  IDM_REFRESH  110

// Function prototypes
int APIENTRY WinMain(HANDLE, HANDLE, LPSTR, int);
BOOL InitApp(HANDLE);
BOOL InitInstance(HANDLE, int);
BOOL TermInstance(HANDLE);
LONG FAR APIENTRY FrameWndProc(HWND, UINT, UINT, LONG);
BOOL FAR APIENTRY AboutDlgProc (HWND, UINT, UINT, LONG);
WORD FAR APIENTRY TimerProc(HWND, UINT, UINT, LONG);
LONG DoDestroy(HWND, UINT, UINT, LONG);
LONG DoClose(HWND, UINT, UINT, LONG);
LONG DoPaint(HWND, UINT, UINT, LONG);
LONG DoSize(HWND, UINT, UINT, LONG);
LONG DoSetFocus(HWND, UINT, UINT, LONG);
LONG DoCommand(HWND, UINT, UINT, LONG);
LONG DoVScroll(HWND, UINT, UINT, LONG);
LONG DoMenuExit(HWND, UINT, UINT, LONG);
LONG DoMenuAbout(HWND, UINT, UINT, LONG);
LONG DoDisplayType(HWND, UINT, UINT, LONG);
LONG DoRefresh(HWND, UINT, UINT, LONG);
VOID Repaint(VOID);
VOID ConfigWindow(VOID);
VOID PaintLine(HDC hdc, INT line);
VOID AddLine(char *);
VOID SetCurLine(INT);
VOID SetWindowCaption(char *);
VOID UpdateProfile(VOID);
VOID EmptyLines(VOID);
VOID WalkModuleList(VOID);
VOID WalkClassList(VOID);
VOID WalkTaskList(VOID);
VOID WalkGlobalHeap(VOID);
VOID ShowMemManInfo(VOID);
VOID ShowSystemHeap(VOID);
VOID ShowDiskSpace(VOID);



