                      Notes on MS-DOS Perl
                Len Reed <holos0!lbr@gatech.edu>
                         September, 1991


Note: the documentation relating to using MS-DOS perl has been
incorporated into the main manual.  See the section below on the
manual.

Copying
-------
MS-DOS perl may be distributed under the terms of the Gnu public
license or the artistic license.  You should have received copies
of the files License and Artistic.


Warranty
--------
This is free software.  It comes with no warranty of any kind.


Obtaining the Source Code
-------------------------

The standard perl source may be obtained from numerous public
archive sources, and is available for anonymous ftp from
<jpl-devvax.Jpl.Nasa.Gov>.  The MS-DOS changes incorporated into
this version are not yet publically available, but should be
soon.

Carriage-Return/Line-feed Fixup
-------------------------------
This package has been back and forth from Unix to MS-DOS many
times.  If your MS-DOS text files, e.g., a manual or batch file,
are missing the carriage returns, the following will insert them:

a    perl -i.bak -pe ";" file [file ...]

The ";" is a null perl script, the fixup is accomplished by
reading a text file (which converts CR/LF ==> LF but passes LFs
unmolested) and writing it (which converts LF==>CR/LF).


Functionality
-------------
Several standard perl commands are not supported by MS-DOS perl
for this simple reason that MS-DOS does not support many basic
Unix functions like fork(), pipe(), and wait().  Use of these
functions and many other like them will result in a fatal error. 
See the manual for details.  All text processing features are
intact.

The other limiting factor in using MS-DOS perl is memory.  The
executable takes over 300 K-bytes before it starts calling
malloc().  And it loves to call malloc().  You'll need 640K.  An
80286 with MS-DOS 5.0 running in high memory will help.  If you
have an 80386 perl will find and use "upper memory" if available. 
(Refer to Microsoft's documentation on XMS and MS-DOS 5.0.)

Subprocesses are always run to completion, since MS-DOS doesn't
support multi-tasking.  Pipes are emulated by using temporary
files.  MS-DOS perl can swap itself to disk (ideally a RAM disk
in extended or expanded memory) so that the subprocess has space
to run.

MS-DOS perl is compatible with the MKS toolkit: it can pass and
receive extended argument lists to/from MKS tools.

To read and write binary files, use the binmode command.  (See
the manual.)

The chdir function has been enhanced to allow changing the drive
and/or the directory.

The Gnu version of dbm (gdbm) has been added to MS-DOS perl.

The perl debugger works as described in the manual, but it takes
a lot of memory, so you won't be able to use it to debug any
complicated.  (Bit of a Catch-22, I'm afraid.)


Things To Do
------------
The globbing for non-MKS users is pretty bad: the Microsoft
globbing routines are used, and they're pretty primitive.

Some users have expressed an interest in 4DOS argument-passing
compatibility.

Network communication (sockets) is not implemented.  There's a
need for a freely distributable sockets library that works with a
variety of network cards.

The exec() function is poorly implemented.  Without forks it's
not too useful, and hence the considerable work required to make
it function properly has been repeatedly put off.

MS-DOS perl takes too much memory.  There's a lot of code that
doesn't do anything useful under MS-DOS but that is nevertheless
compiled in.

I'm convinced that the exec-swapping code is not general enough
for the worst case.  (That code was adapted from Dennis Vadura's
dmake program.)  There may also be some memory leakage due to
bugs in Microsoft's malloc library code.

For the truly ambitious, perl could be ported to gcc for i386 MS-
DOS.  It could then run in 32-bit mode with large amounts of
memory.  That would be a big project and really should use this
port only as a basepoint: it should remain separate.  Any
takers? :-)

See also Wishlist.dds.


The Perl Manual
---------------
If you got this file as part of the complete perl source
distribution, you can make one of three manuals from the n/troff
manual source: the standard Unix manual, an MS-DOS manual, or a
combined Unix/MS-DOS manual.  Near the top of that file there's a
string register that gets set to 'unix', 'msdos', or 'both'.  The
'unix' version has little mention of MS-DOS, the 'both' version
includes additional commentary on MS-DOS and a section on "MS-DOS
Considerations."  The 'msdos' version omits large sections of the
standard manual that are not relevant to MS-DOS: every command is
mentioned, but many simply note that they are not supported on
MS-DOS.

If you got this file as part of an MS-DOS executable kit, you
should have received a formatted manual in that kit: perldos.man.
This manual contains simple highlighting in the form of boldface
and underlining accomplished by backspacing.  There is a one-line
script in the eg directory (nohigh.bat) that will remove the
highlighting.

     perl -p eg/nohigh.bat perldos.man > perldos.van

This will create perldos.van without highlighting.

Only the perl.exe file is needed for this script; it doesn't
require a full installation of perl.

The versions of the manual that include MS-DOS commentary are not
major re-writes; many of the examples have Unixisms that won't
work on MS-DOS without some changes.

Beware that the "Camel" book, the only text on perl, barely
mentions MS-DOS.  Nevertheless, this book should prove useful to
the MS-DOS perl programmer.


Installing MS-DOS Perl
----------------------
Put perl.exe into a directory in your PATH.  Put perlglob.exe
into that directory, too.  (Not needed for MKS users.)  If you
wish to use the -P switch, copy doscpp.pl to a library directory. 
(If you don't have Microsoft C 6.0 you'll have to edit this
file.)  If you want to use the perl debugger, copy perldb.pl to
the library directory, too.  Set up your environment as explained
in the manual.

Building MS-DOS Perl from the Source
------------------------------------
Apply the patches to the standard 4.019 source.

This code will compile only on Microsoft C, 5.0, 5.1, or 6.0. 
The last of these produces the best code.  (It may be possible to
cross-compile from SCO Xenix or Unix, since these cross-compilers
are close relatives of the Microsoft compilers.)  The makefile is
specific to Dennis Vadura's dmake program; if you don't have
this, get it.  (See the makefile for the ftp address.)  There are
batch files build5.bat and build6.bat to build perl.exe with
Microsoft C 5.x and 6.0, respectively, if you don't have dmake.

If you wish to include gdbm, you'll have to obtain it.  Be sure
to get the MS-DOS version.  I used version 1.4, with MS-DOS
patches by Thorsten Ohl <td12@@ddagsi3.bitnet>.  Build the
library (LGDBM.LIB) and copy it to the directory with the
compiler libraries.  Copy the files "ndbm.h" and "gdbmdefs.h" to
the compiler include file directory.  Enable the GDBM option in
the makefile or edit the batch script or the config.h file to
define HAS_NDBM.  Do not copy any other gdbm header files: in
particular, "extern.h" will conflict with perl's extern.h.

Don't run Configure for MS-DOS: a pre-made config.h file is found
in the msdos subdirectory.

Edit the makefile at the top to select the options you need.  (Or
edit the batch file, using the makefile as a guide.)  The
makefile will attempt to run BISON to create perly.c and perly.h
from perly.y.  You can instead import your Unix-made version of
these files.  (These are independent of platform, so you don't
need to do anything to the Unix versions.  If using Unix yacc, be
sure to copy over the version that had perlyfixer.sh run against
it.)

Build perl.exe in the msdos subdirectory.

You'll need free XMS memory to run the Microsoft Codeview
debugger on perl.


Running the Test Suite
----------------------
This section applies only if you're building MS-DOS perl from the
source.  The test suite has been altered to run under MS-DOS. 
Tests that aren't relevant under MS-DOS are if'ed around, so all
tests should pass.  You'll need a lot of Unix-like tools (e.g.,
rm); I used the MKS toolkit.  Copy perl.exe into the "t"
directory.  Set up the environment and install doscpp.pl.


You can't just run "perl test" since you'll run out of memory. 
Try running each directory of tests, e.g.,
    ./perl test base/*.t"

It may be necessary to break this even finer, some of the
directories have a lot of tests.


History of MS-DOS Perl
----------------------
Larry Wall wrote perl, and continues to enhance it.  While he has
done no direct work on MS-DOS perl, most of the code in MS-DOS
perl is his since most of the code concerns portable features.

Perl was originally ported to MS-DOS by Diomidis Spinellis.  His
code was distributed with version 3, patch level 18 (3.018). 
This was in April, 1990.

Len Reed's executable version based upon 3.041 source with
considerable enhancements was posted to USENET
comp.binaries.ibm.pc in November, 1990.  This version included
considerable minor bug fixes, swapping to disk while running
subprocesses, "smarter" subprocesses (i.e., don't use COMMAND.COM
if you don't need it), MKS toolkit compatibility, support for
the -P switch, enhanced chdir semantics, and enhanced support for
the -i switch.  (The last two of these due to Tom Dinger.)

Tom Dinger cleaned up the released MS-DOS source code after perl
4.x came out.  By 4.010, he had put the following into the
standard sources: enhanced chdir, enhanced -i support, several
bug fixes.  He also created the msdos/config.h file.

In September 1991, I (Len Reed) added the functions that were in
my 3.041 version that hadn't been incorporated into the standard
4.010 source: notably swapping, smarter subprocesses, support
for -P, and MKS compatibility.  I fixed some minor bugs.  I added
gdbm support.  I altered the test suite to work with MS-DOS.  I
put MS-DOS support into the main manual and reworked the other
documentation, including this file.


The Authors
-----------
Larry Wall         <lwall@netlabs.com>
Diomidis Spinellis <dds@cc.ic.ac.uk>
Len Reed           <holos0!lbr@gatech.edu>
Tom Dinger         <tdinger@East.Sun.Com>

The address for Diomidis Spinellis may be out of date.
