#include <dos.h>
#include "pcrobots.h"

void    	swaptask(void)
{
 _AX=0;
 geninterrupt(0xe0);
}

void    	movement(int speed,int angle)
{
 _BX=speed;
 _CX=angle;
 _AX=1;
 geninterrupt(0xe0);
}

int 	scan(int angle,int res,int *range)
{
 int ax,bx;
 _BX=angle;
 _CX=res;
 _AX=2;
 geninterrupt(0xe0);
 ax=_AX;
 bx=_BX;
 *range=bx;
 return ax;
}

int 		shoot(int angle,int range)
{
 _BX=angle;
 _CX=range;
 _AX=3;
 geninterrupt(0xe0);
 return _AX;
}

void    	getxy(int *x,int *y)
{
 int x1;

 _AX=0x10;
 geninterrupt(0xe0);
 x1=_BX;
 *x=x1;
 *y=_CX;
}

int		transmit(int target,int data)
{
 _BX=target;
 _CX=data;
 _AX=0x11;
 geninterrupt(0xe0);
 return _AX;
}

int     	receive(int *source,int *data)
{
 int ax,bx;

 _AX=0x12;
 geninterrupt(0xe0);
 ax=_AX;
 bx=_BX;
 *data=_CX;
 *source=bx;
 return ax;
}


int 		damage(void)
{
 _AX=0x13;
 geninterrupt(0xe0);
 return _BX;
}
int		speed(void)
{
 _AX=0x14;
 geninterrupt(0xe0);
 return _BX;
}

int 		battery(void)
{
 _AX=0x15;
 geninterrupt(0xe0);
 return _BX;
}

long    	ticks(void)
{

 _AX=0x16;
 geninterrupt(0xe0);

 return ((long)_BX<<16)|_CX;
}

long    	l_sin(int angle)
{

 _BX=angle;
 _AX=0x17;
 geninterrupt(0xe0);

 return ((long)_BX<<16)|_CX;
}


long    	l_cos(int angle)
{

 _BX=angle;
 _AX=0x18;
 geninterrupt(0xe0);

 return ((long)_BX<<16)|_CX;
}

long    	l_tan(int angle)
{

 _BX=angle;
 _AX=0x19;
 geninterrupt(0xe0);

 return ((long)_BX<<16)|_CX;
}

int     l_atan(long ratio)
{

 _BX=(int)((unsigned long)ratio>>16);
 _CX=(int)(ratio);
 _AX=0x1a;
 geninterrupt(0xe0);

 return _AX;
}

long    	l_sqrt(long value)
{

 _BX=(int)((unsigned long)value>>16);
 _CX=(int)(value);
 _AX=0x1b;
 geninterrupt(0xe0);

 return ((long)_BX<<16)|_CX;
}

void    	set_pattern(const char far *ptr)
{
 _CX=FP_OFF(ptr);
 _BX=FP_SEG(ptr);
 _AX=0x1C;
 geninterrupt(0xe0);
}

void    	debug_flag(int   flag,int set)
{
 _CX=set;
 _BX=flag;
 _AX=0x1d;
 geninterrupt(0xe0);
}

void		buy_armour(int armour_units)
{
 _BX=armour_units;
 _AX=0x1e;
 geninterrupt(0xe0);
}

void		buy_shells(unsigned int shells)
{
 _BX=shells;
 _AX=0x1f;
 geninterrupt(0xe0);
}

int 		shells_left(void)
{
 _AX=0x20;
 geninterrupt(0xe0);
 return _BX;
}

void    	get_local_map(char far *ptr)
{
 _CX=FP_OFF(ptr);
 _BX=FP_SEG(ptr);
 _AX=0x21;
 geninterrupt(0xe0);
}

void    	invisibility(int invis_flag)
{
 _BX=invis_flag;
 _AX=0x22;
 geninterrupt(0xe0);
}

int		get_shell_status(void)
{
 _AX=0x23;
 geninterrupt(0xe0);
 return _BX;
}

int		is_invisible(void)
{
 _AX=0x24;
 geninterrupt(0xe0);
 return _BX;
}

int     l_atan2(int y,int x)
{

 _BX=y;
 _CX=x;
 _AX=0x25;
 geninterrupt(0xe0);

 return _AX;
}

int     get_robot_id(void)
{
 _AX=0x26;
 geninterrupt(0xe0);
 return _AX;
}

void    register_iff(char far *iff_str)
{
 _CX=FP_OFF(iff_str);
 _BX=FP_SEG(iff_str);
 _AX=0x27;
 geninterrupt(0xe0);
}

int     check_iff(int id)
{
 _BX=id;
 _AX=0x28;
 geninterrupt(0xe0);
 return _AX;
}

void    register_name(char far *name_str)
{
 _CX=FP_OFF(name_str);
 _BX=FP_SEG(name_str);
 _AX=0x29;
 geninterrupt(0xe0);
}

int     find_name(int start_id,char far *name_str)
{
 _CX=FP_OFF(name_str);
 _BX=FP_SEG(name_str);
 _DX=start_id;
 _AX=0x2a;
 geninterrupt(0xe0);
 return _AX;
}

int     get_team_id(void)
{
 _AX=0x2b;
 geninterrupt(0xe0);
 return _AX;
}

int	get_ashell_status(unsigned int shellid)
{
 _BX=shellid;
 _AX=0x2c;
 geninterrupt(0xe0);
 return _AX;
}

int	register_x(int far *xvar)
{
 _CX=FP_OFF(xvar);
 _BX=FP_SEG(xvar);
 _AX=0x2d;
 geninterrupt(0xe0);
 return _AX;
}

int	register_y(int far *yvar)
{
 _CX=FP_OFF(yvar);
 _BX=FP_SEG(yvar);
 _AX=0x2e;
 geninterrupt(0xe0);
 return _AX;
}

int    	configure(int	speed,int manouevre,int range,
			int armour,int acceleration,
			int invisibility)
{
 unsigned int bx=(speed&7)+((manouevre&7)<<4)+((range&7)<<8)+((armour&7)<<12);
 long x=(long)getvect(0xe0);
/* Exit if PCRobots vector isn't initialised.
   I don't print anything as the printing routines can be quite large
*/
 if (x==0)
  exit(1);
 _CX=(acceleration&7)+((invisibility&1)<<3);
 _BX=bx;
 _AX=0x80;
 geninterrupt(0xe0);

 return (_AX);
}

