.TH PRFORM 1 "16 June 1988"
.SH NAME
PRFORM - A PRintout FORMatter in C
.SH SYNOPSIS

PRFORM is invoked by a command line of the following form:

.ce
prform [[-option -option ...] file1 file2 ...] ...

.ce
- or -

.ce
prform [-option -option ...]

where the options preceeding each group of files specify the format of
the output for that group of files.  In the first form, PRFORM acts on
the specified files; in the second form, PRFORM acts on standard input.

Options are:

.nf
  -a       as-is output (expand tabs and page breaks only)
  -e#      end printing after the #th page
  -E       no ending line number in page count
  -hfMprt  sets the page heading
     f   places the file name into the page heading
     M   places the header message (defined by -M)
          into the page heading
     p   places the page number into the page heading
     r   places the rest of the heading on the right side
     t   places the date and time into the page heading
         no option after h sets no page heading
          (default option sequence is frp)
  -hefMprt sets the page heading for even pages
          (default option sequence is )
  -hofMprt sets the page heading for odd pages
          (default option sequence is )
  -H       prints this help message on stderr and exits
  -l#      is the length of a line (def 80)
  -m#      is the length of the left margin (def 5)
  -M<text> sets the header message to <text>
  -n       causes each line to be numbered (-M set to 8)
  -o<name> redirects the output listing to the indicated file
  -p#      is the number of lines/page (def 62)
  -s#      start printing at the #th page (def 1)
          (note: also does -S#, setting first page number)
  -S#      sets the number of the first printed page
  -t#      is the number of columns per tab stop (def 8)
  -T       truncate lines which are too long

.fi
.SH DESCRIPTION
.PP
PRFORM generates a formatted listing of one or more text files.
The listing can include features such as headers at the top of each
page, numbers in front of each line, wraparound if lines exceed the
width of a page, page breaks after an indicated number of lines, etc.
The listing can start on a specified page if desired.  PRFORM sends
its output to either standard output (default) or a text file.
.PP
PRFORM functions as either a conventional program, processing files
specified on its command line, or as a filter, obtaining its input
from standard input.  If no files are specified on the command line
(only zero or more options), then PRFORM inputs from standard input.
.PP
Most of the options to PRFORM are self-explanatory.  Each group of
options encountered in the command line causes a reset to the default
options and then a setting of the indicated options, so previous
options selections are overridden; example:
.sp 1
.in +5
.nf
prform -a -m5 file1 -m0 file2
       \\____/       \\_/
      Group 1      Group 2

file1 is printed as-is with a 5-char margin
file2 is printed with all defaults and no margin
.fi


.sp 2
.ce
.ul
As-Is Output
.PP
The -a option causes the file to be output as-is.  All option
are set by this command to the following values:
.sp 1
.rm -5
.in +5
Lines are not truncated.

No heading is output (default heading, even-page heading, and odd-page
heading are cleared).

Line length is set to the maximum allowed for the program (400 characters).

Left margin is set to zero.

Line numbering is turned off.

Number of lines per page is set to zero (no paging).

Starting page is set to 1.

Tab stops are set to every 8.

.rm +5
.in -5
.sp 1
.PP
The -a option can be followed by other options, such as -m#, to set
a bare output with the exception of some minimum processing (such as
a left margin).

.sp 2
.ce
.ul
Line Wraparound and Truncation
.PP
If the length of a line exceeds the number of characters specified
by the -l (ell) option or its default value, that line will either wrap
around to the next line of the printout or be truncated.  If the -T
option is specified, the line will be truncated; if not, the line will
wrap around, and the continuation line is prefixed by two greater than
signs (>>) on the far left.

.rm -5
.in +5
.ti -3
.ul
-l70
sets the line length to 70 characters total (including the left margin).

.ti -3
.ul
-l70 -m10
sets the line length to 70 characters and the left margin to 10.
There is a maximum of 60 characters in each output line.

.ti -3
.ul
-T -l50
sets the line length to 50 characters and enables truncation of any
characters beyond column 50 in the generated listing.

.rm +5
.in -5
.sp 2
.ce
.ul
Page Ranges and Page Numbering
.PP
The -s# and -e# commands set the starting and ending page boundaries.
If the -s# command is not given, the output starts at the first page.
If the -e# command is not given, the output ends at the last page.
The arguments to these commands are absolute page numbers, indicating
the nth physical page in the listing.  This is as opposed to the -S#
command.
.PP
The -S# command sets the number of the first page to be printed.
If the -S# command is not given, this number is the same as the
absolute number of the first printed page (same as the number given
in the -s# command).  The number given by the -S# command is the number
that appears in the page heading for the first page printed, and each
page printed after that is incremented from this starting number.
.PP
The -E command causes the page numbers printed in the heading to
omit the " of n" part of the output (eg, without -E the heading contains
"Page 1 of 5", but with -E the heading contains "Page 1").

.rm -5
.in +5
.ti -3
.ul
-s5 -e7
causes the 5th through the 7th pages to be printed.

.ti -3
.ul
-s10 -e20 -S1
causes the 10th through the 20th pages to be printed, and the 10th
page is numbered 1, the 11th page is 2, etc., to the 20th page, which
is numbered 11.

.ti -3
.ul
-s10 -e20 -ES1
is the same as above except the page headers do not contain the
number of the last page (the " of n" part is omitted from the page
number).

.rm +5
.in -5
.sp 2

.ce
.ul
Page Headings
.PP
The heading options provide for a declaration of a general page
heading, a heading for even-numbered pages, and a heading for odd-numbered
pages.  If a heading for even-numbered pages is not specified, the general
page heading is used; likewise for odd-numbered pages.
.PP
A heading can consist of up to four components: the name of the file
(f option), some user-specified message (M option),
the page number (p option), and the date and time of the
printout (t option).  The user-specified message is provided by the -M
option; example:
.sp 1
.ce
"-Mmy heading text" -hM
.sp 1
sets "my heading text" as the user-specified message and sets the header
to output only that text.
Each selected component (except for the user-specified message)
is followed by four spaces so that the
selected components are separated from each other.  An r option is also
available to make the components following this option to be right-justified
on the heading line.  For example:

.in +5
.rm -5
.ti -3
.ul
-MListing -hpfM
places the page number followed by the file name followed by the
text "Listing" on the left side of
the heading line.  All pages are affected unless an -he or -ho
option is specified.

.ti -3
.ul
"-MImportant Listing" -hfMrp
places the file name followed by the text "Important Listing"
on the left side of the heading line and the
page number on the right side (justified against the right margin).
All pages are affected unless an -he or -ho option is specified.
Note the use of quotes to enclose the -M<text> string when spaces are
to be included in the <text>.

.ti -3
.ul
-hofrp -heprf
places (1) the file name on the left side and the page number on the
right side of odd-numbered pages and (2) the page number on the left side
and the file name on the right side of even-numbered pages.

.ti -3
.ul
-hofrtp -heptrf
places (1) the file name on the left side and the date and
time followed by the page
number on the right side of odd-numbered pages and (2) the page number
followed by the date and time on the left side and the file name on
the right side of even-numbered pages.

.rm +5
.in -5
.PP
See also the -E option in the previous section.

.SH EXAMPLE

.in +5
.rm -5
.ti -3
.ul
prform -hofrp -heprf -l60 myfile.txt -hfrp -t3 test.c
outputs (1) "myfile.txt" with the default values, odd-numbered pages
containing heading lines consisting of the file name on the left and
the page number on the right, even-numbered pages containing heading
lines consisting of the page number on the left and the file name on
the right, and 60 characters in each output line
and (2) "test.c" with the default values (including 80 characters
in each output line), heading lines on
both odd- and even-numbered pages consisting of the file name on the
left and the page number on the right, and tab stops at every 3
columns (note that the second group of options reset all previous
option settings).

.ti -3
.ul
prform "-MC Programs: " -hMfrp *.c | lpr
outputs all files matching "*.c" to standard output, which is piped
to the line printer spooler.  A form feed is placed after each file,
and page and line numbered start fresh with each file.  The user-specified
heading text is set to "C Programs: " and the page headings
consist of the user-specified message followed by the file name
on the left and the page number on the right.  Note that
the trailing space
after the colon of the heading message was placed there because
the message is the only parameter in the -h option list which is
not followed by four spaces. 

.ti -3
.ul
nroff -man file.1 | prform -a -m5 | lpr
runs nroff on file.1, pipes the output from nroff into prform (which
outputs it as-is was a left margin of 5 spaces added), and pipes the
prform output to the lpr program.  The net effect of this command is
to print the formatted file.1 with a left margin of 5 spaces on each
line.

.rm +5
.in -5

.SH FILES

prform - executable

prform.c - source

prform.l - man file

/tmp/prform# - temporary file created when input is provided
on standard input rather than from a specified file (this file
is deleted from /tmp when prform successfully completes)

.SH DIAGNOSTICS

.rm -5
.in +5
.ti -3
.ul
Cannot Open Output File <filename>
is issued when the -ffilename option is specified and the output file
cannot be created for some reason.  This is a fatal error, causing the
program to abort.

.ti -3
.ul
Cannot Create Temporary File <filename>
is issued with the input to PRFORM is obtained from standard input
and it cannot create the copy of the input in the /tmp/prform* file
for some reason (out of space in /tmp, etc.).

.ti -3
.ul
Cannot Open <filename>
or
.ul
Cannot Open Temporary File <filename>
is issued when PRFORM is beginning its second pass and cannot open
the input file.

.ti -3
.ul
Invalid Option at <text>
is issued when an invalid option is encountered on the command line.
The text starts with the invalid option character.  This is a fatal error,
causing the program to abort.

.rm +5
.in -5

.SH BUGS
.PP
Input and output line lengths should not exceed 400 characters.

.SH AUTHOR

PRFORM Version 1.x (Beta Test) was written by Richard Conn.
