unit page_15;

interface

uses crt, ifpglobl, ifpcomon;

procedure page15;

implementation

procedure page15;

var
  drive : byte;
  j : 0..3;
  k : byte;
  part : array[0..secsiz - 1] of byte;
  EndOfDrives : boolean;
  ValidDrive : boolean;
  LastDrive : boolean;
  AnotherDrive : boolean;
  xbyte : byte;
  xlong : longint;
  xword : word;

  begin
  caption2('Partition table data');
  if ReadPartitionTable then
    begin
    drive:=$80;
    EndOfDrives:=false;
    ValidDrive:=false;
    repeat
      with regs do
        begin
        AX:=$0201;
        CX:=$0001;
        DX:=drive;
        ES:=Seg(part);
        BX:=Ofs(part);
        Intr($13, regs);
        if NoCarry(regs) then
          begin
          EndOfDrives:=true;
          ValidDrive:=true
          end
        else
          if drive < $99 then
            Inc(drive)
          else
            EndOfDrives:=true
        end
    until EndOfDrives;
    if ValidDrive then
      begin
      Writeln;
      caption3('Unit');
      Writeln;
      caption3('Partition');
      Writeln;
      caption3('Bootable');
      Writeln;
      caption3('Starting head');
      Writeln;
      caption3('Starting sector');
      Writeln;
      caption3('Starting cylinder');
      Writeln;
      caption3('System ID');
      Writeln;
      caption3('Ending head');
      Writeln;
      caption3('Ending sector');
      Writeln;
      caption3('Ending cylinder');
      Writeln;
      caption3('First partition sector');
      Writeln;
      caption3('Sectors in partition');
      Writeln;
      LastDrive:=false;
      repeat
        Window(9, 4, twidth, tlength - 2);
        Writeln(drive);
        Window(27, 5, twidth, tlength - 2);
        ClrScr;
        for j:=0 to 3 do
          begin
          Window(27 + 12 * j, 5, 38 + 12 * j, tlength - 2);
          Writeln(j + 1);
          xword:=$01BE + j shl 4;
          xbyte:=part[xword];
          case xbyte of
            $00 : Writeln('no');
            $80 : Writeln('yes')
          else
              Writeln('(', hex(xbyte, 2), ')')
          end;
          xbyte:=part[xword + 4];
          if xbyte > $00 then
            begin
            Writeln(part[xword + 1]);
            Writeln(part[xword + 2] and $3F);
            Writeln(part[xword + 3] +
              word(part[xword + 2] shr 6 * 256));
            case xbyte of
              $00 : Write('None');
              $01 : Write('DOS-12');
              $02 : Write('XENIX root');
              $03 : Write('XENIX /usr');
              $04 : Write('DOS-16');
              $05 : Write('Ext DOS-16');
              $06 : Write('Big DOS-16');
              $07 : Write('OS/2 HPFS');
              $08 : Write('AIX data');
              $09 : Write('AIX boot');
              $0A : Write('OS/2 BtMngr');
              $10 : Write('OPUS');
              $40 : Write('VENIX 286');
              $44 : Write('386BSD');
              $50 : Write('DskMngrR/O');
              $51 : Write('Dsk Managr');
              $52 : Write('CP/M');
              $56 : Write('GB Vfeatre');
              $61 : Write('Speedstor');
              $63 : Write('SysV/386');
              $64 : Write('NOVELL');
              $75 : Write('PC/IX');
              $80 : Write('Minix v1.3-');
              $81 : Write('Minix v1.4+');
              $82 : Write('Minix Swap');
              $83 : Write('Linux extd');
              $93 : Write('Amoeba file');
              $94 : Write('Amoeba BBT');
              $B7 : Write('BSDI file');
              $BB : Write('BSDI swap');
              $C6 : Write('DRDOSsecure');
              $C7 : Write('Cyrnix boot');
              $DB : Write('CP/M');
              $E1 : Write('SpdStr-12');
              $E3 : Write('SpdStr R/O');
              $E4 : Write('SpdStr-16');
              $F2 : Write('DOS secndry');
              $FE : Write('LANstep');
              $FF : Write('Xenix BBT')
            else
              Write('(', hex(xbyte, 2), ')')
            end;
            Writeln;
            Writeln(part[xword + 5]);
            xbyte:=part[xword + 6];
            Writeln(xbyte and $3F);
            Writeln(cbw(part[xword + 7], xbyte shr 6));
            xlong:=0;
            for k:=11 downto 8 do
              xlong:=xlong shl 8 + part[xword + k];
            Writeln(xlong);
            xlong:=0;
            for k:=15 downto 12 do
              xlong:=xlong shl 8 + part[xword + k];
            Writeln(xlong)
          end
        else
           for k:=1 to 9 do
             Writeln('-')
        end;
        AnotherDrive:=false;
        repeat
          if drive < $99 then
            begin
            Inc(drive);
            with regs do
              begin
              AX:=$0201;
              CX:=$0001;
              DX:=drive;
              ES:=Seg(part);
              BX:=Ofs(part);
              Intr($13, regs);
              if NoCarry(regs) then
                begin
                AnotherDrive:=true;
                Pause1;
                if endit then
                  Exit;
                end
              end
            end
          else
            begin
            LastDrive:=true;
            AnotherDrive:=true
            end
        until AnotherDrive
      until LastDrive
      end
    else
      Writeln('(no fixed disks)')
    end
  else
    begin
    Writeln;
    Writeln('Reading of Partition Table blocked by NP command-line switch!!');
    end;
  end;
end.