/* MS-DOS SHELL - Data Declarations
 *
 * MS-DOS SHELL - Copyright (c) 1990,1,2 Data Logic Limited and Charles Forsyth
 *
 * This code is based on (in part) the shell program written by Charles
 * Forsyth and is subject to the following copyright restrictions:
 *
 * 1.  Redistribution and use in source and binary forms are permitted
 *     provided that the above copyright notice is duplicated in the
 *     source form and the copyright notice in file sh6.c is displayed
 *     on entry to the program.
 *
 * 2.  The sources (or parts thereof) or objects generated from the sources
 *     (or parts of sources) cannot be sold under any circumstances.
 *
 *    $Header: /usr/users/istewart/src/shell/sh2.1/RCS/sh6.c,v 2.4 1992/12/14 10:54:56 istewart Exp $
 *
 *    $Log: sh6.c,v $
 *	Revision 2.4  1992/12/14  10:54:56  istewart
 *	BETA 215 Fixes and 2.1 Release
 *
 *	Revision 2.3  1992/11/06  10:03:44  istewart
 *	214 Beta test updates
 *
 *	Revision 2.2  1992/09/03  18:54:45  istewart
 *	Beta 213 Updates
 *
 *	Revision 2.1  1992/07/10  10:52:48  istewart
 *	211 Beta updates
 *
 *	Revision 2.0  1992/04/13  17:39:09  Ian_Stewartson
 *	MS-Shell 2.0 Baseline release
 *
 *
 */

#include <sys/types.h>
#include <stddef.h>
#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <setjmp.h>
#include <stdlib.h>
#include <limits.h>
#include <dirent.h>
#include <unistd.h>
#include <string.h>
#ifdef OS2
#define INCL_DOSSESMGR
#include <os2.h>
#endif
#include "sh.h"

#ifdef OS2
static char	*Copy_Right1 = "MS-DOS SH Version 2.1 (%s) - %s (OS/2 %d.%d)\n";
#else
static char	*Copy_Right1 = "MS-DOS SH Version 2.1 (%s) - %s (DOS %d.%d)\n";
#endif
static char	*Copy_Right2 = "Copyright (c) Data Logic Ltd and Charles Forsyth 1990, 91, 92\n";
char		**ParameterArray = (char **)NULL; /* Parameter array	*/
int		ParameterCount = 0;	/* # entries in parameter array	*/
int		ExitStatus;		/* Exit status			*/
bool		ExpansionErrorDetected;
				/* interactive (talking-type wireless)	*/
bool		InteractiveFlag = FALSE;
bool		ProcessingEXECCommand;	/* Exec mode			*/
bool		UseConsoleBuffer = FALSE;/* Flag from dofc to		*/
					/* GetConsoleInput		*/
int		AllowMultipleLines;	/* Allow continuation onto	*/
					/* Next line			*/
int		Current_Event = 0;	/* Current history event	*/
bool		ChangeInitLoad = FALSE;	/* Change load .ini pt.		*/
unsigned char	GlobalFlags = 0;	/* Other global flags		*/

int		*FailReturnPoint;	/* Current fail jump address	*/
int		*ErrorReturnPoint;	/* Current error jump address	*/
int		DisabledVariables = 0;	/* Disabled variables		*/

#ifdef OS2
unsigned int	SW_intr;		/* Interrupt flag		*/
char		path_line[FFNAME_MAX];	/* Execution path		*/
#else
					/* Swap mode			*/
int		Swap_Mode = SWAP_EXPAND | SWAP_DISK;
#endif
Break_C		*Break_List;	/* Break list for FOR/WHILE		*/
Break_C		*Return_List;	/* Return list for RETURN		*/
Break_C		*SShell_List;	/* SubShell list for EXIT		*/
bool		RestrictedShellFlag = FALSE;	/* Restricted shell	*/
				/* History processing enabled flag	*/
bool		HistoryEnabled = FALSE;

void		*FunctionTree = (void *)NULL;	/* Function tree	*/
FunctionList	*CurrentFunction = (FunctionList *)NULL;
void		*AliasTree = (void *)NULL;	/* Alias tree		*/
#ifdef OS2
void		*JobTree = (void *)NULL;	/* job tree		*/
bool		ExitWithJobsActive = FALSE;	/* Exit flag		*/
int		CurrentJob = 0;			/* No current		*/
int		PreviousJob = 0;		/* Previous Job		*/
#endif

Save_IO		*SSave_IO;	/* Save IO array			*/
int		NSave_IO_E = 0;	/* Number of entries in Save IO array	*/
int		MSave_IO_E = 0;	/* Max Number of entries in SSave_IO	*/
S_SubShell	*SubShells;	/* Save Vars array			*/
int		NSubShells = 0;	/* Number of entries in SubShells	*/
int		MSubShells = 0;	/* Max Number of entries in SubShells	*/
int		LastNumberBase = -1;	/* Last base entered		*/

Word_B		*WordListBlock;	/* Current Word List			*/
Word_B		*IOActionBlock;	/* Current IO List			*/
int		InterruptTrapPending;	/* Trap pending			*/
int		Execute_stack_depth;	/* execute function recursion	*/
					/* depth			*/
void		*VariableTree = (void *)NULL;	/* Variable dictionary	*/
VariableList	*CurrentDirectory;	/* Current directory		*/
char		*LastUserPrompt;	/* Last prompt output		*/
char		*LastUserPrompt1;	/* Alternate Last prompt output	*/
char		IFS[] = "IFS";		/* Inter-field separator	*/
char		PS1[] = "PS1";		/* Prompt 1			*/
char		PS2[] = "PS2";		/* Prompt 2			*/
char		PS3[] = "PS3";		/* Prompt 3			*/
char		PS4[] = "PS4";		/* Prompt 4			*/
char		PathLiteral[] = "PATH";
char		HomeVariableName[] = "HOME";
char		ShellVariableName[] = "SHELL";
char		HistoryFileVariable[] = "HISTFILE";
char		HistorySizeVariable[] = "HISTSIZE";
char		*ComspecVariable= "COMSPEC";
char		*ParameterCountVariable = "#";
char		*ShellOptionsVariable = "-";
char		*StatusVariable = "?";
char		*spcl2 = "$`'\"";
char		SecondsVariable[] = "SECONDS";
char		RandomVariable[] = "RANDOM";
char		LineCountVariable[] = "LINENO";
char		*OldPWDVariable = "OLDPWD";
char		*PWDVariable = "PWD";
char		*ENVVariable = "ENV";
bool		FirstReadFromUser = TRUE;
#ifdef OS2
char		BATExtension[] = ".cmd";
#else
char		BATExtension[] = ".bat";
#endif
char		SHELLExtension[] = ".sh";
char		EXEExtension[] = ".exe";
char		COMExtension[] = ".com";
char		*NotFound = "not found";
char		*BasicErrorMessage = "%s: %s\n";
char		*DirectorySeparator = "/";
char		LastWordVariable[] = "_";
char		OptArgVariable[] = "OPTARG";
char		OptIndVariable[] = "OPTIND";
char		MailCheckVariable[] = "MAILCHECK";
char		*Trap_DEBUG = "~DEBUG";
char		*Trap_ERR = "~ERR";
char		LIT_export[] = "export";
char		LIT_exit[] = "exit";
char		LIT_exec[] = "exec";
char		LIT_history[] = "history";
char		LIT_REPLY[] = "REPLY";
char		LIT_LINES[] = "LINES";
char		LIT_COLUMNS[] = "COLUMNS";
char		*ListVarFormat = "%s=%s\n";
char		*Outofmemory1 = "Out of memory";
char		*LIT_Emsg = "%s: %s (%s)\n";
char		*LIT_2Strings = "%s %s\n";
char		*LIT_3Strings = "%s %s%s\n";

#ifdef OS2
STARTDATA	*SessionControlBlock;	/* Start a session info		*/
#endif

/*
 * Global program mode information
 */

struct ExecutableProcessing 	ExecProcessingMode;

/*
 * Modified getopt values
 */

int		OptionIndex = 1;	/* optind			*/
int		OptionStart;		/* start character		*/
char		*OptionArgument;	/* optarg			*/

/*
 * Device directory.  The length of this string is defined by the variable
 * LEN_DEVICE_NAME_HEADER
 */

char		*DeviceNameHeader = "/dev/";

				/* I/O stacks				*/
IO_Args		ioargstack[NPUSH];
IO_State	iostack[NPUSH];

				/* Temporary I/O argument		*/
IO_Args		temparg = {
    (char *)NULL,		/* Word					*/
    (char **)NULL,		/* Word list				*/
    0,				/* File descriptor			*/
    AFID_NOBUF,			/* Buffer id				*/
    0L,				/* File position			*/
    0,				/* Offset in buffer			*/
    (IO_Buf *)NULL		/* Buffer				*/
};

int		MemoryAreaLevel;/* Current allocation area		*/
bool		InParser;	/* In parser flag			*/
long		flags = 0L;	/* Command line flags			*/
char		null[] = "";	/* Null value				*/
char		ConsoleLineBuffer[LINE_MAX + 1]; /* Console line buffer	*/

				/* Current environment			*/
ShellFileEnvironment	e = {
    (char *)NULL,		/* Current line buffer			*/
    (char *)NULL,		/* Current pointer in line		*/
    (char *)NULL,		/* End of line pointer			*/
    iostack,			/* I/O Stack pointers			*/
    iostack - 1,
    (int *)NULL,
    FALSE,			/* End of file processing		*/
    FDBASE,			/* Base file handler			*/
    (Word_B *)NULL,		/* Globbing word block			*/
    (ShellFileEnvironment *)NULL	/* Previous Env pointer		*/
};

/*
 * Some defines to print version and release info
 */

#define str(s)		# s
#define xstr(s)		str(s)

#ifdef OS2
#define OS_VERSION	_osmajor / 10
#else
#define OS_VERSION	_osmajor
#endif

/*
 * The only bit of code in this module prints the version number
 */

void	PrintVersionNumber (FILE *fp)
{
    fprintf (fp, Copy_Right1, xstr (RELEASE), __DATE__, OS_VERSION, _osminor);
    fputs (Copy_Right2, fp);
}
