PROGRAM AriTest;   { Copyright (c) 1990-1993 Norbert Juffa }

{ Aritest tests the speed of the REAL arithmetic software routines. }

{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,R-,S-,V-,X-}

USES Time;

VAR L: INTEGER;
    I, J, ExecutionTime,
    StorageTime, StorageTime2,
    StorageTime3, Start: LONGINT;
    X, Y, Z: REAL;
    A, B, C: ARRAY [1..2900] OF REAL;
    D: ARRAY [1..2900] OF LONGINT;


FUNCTION Draw: INTEGER;
BEGIN
  IF Random < 0.5 THEN
    Draw := -1
  ELSE
    Draw := 1;
END;

BEGIN
   WriteLn;
   WriteLn ('Time for basic arithmetic functions');
   WriteLn;
   Write   ('Operation                Time TP ');
{$IFDEF VER55}
   Write   ('5.5');
{$ENDIF}
{$IFDEF VER50}
   Write   ('5.0');
{$ENDIF}
{$IFDEF VER60}
   Write   ('6.0');
{$ENDIF}
{$IFDEF VER70}
   Write   ('7.0');
{$ENDIF}
   WriteLn;
   WriteLn ('');

   RandSeed := 13;

   Write ('Please wait! Initializing ...');

   FOR L := 1 TO 2900 DO BEGIN
      A [L] := Exp (Random * 80-40);
   END;
   FOR L := 1 TO 2900 DO BEGIN
      B [L] := Exp (Random * 8.8-4.4) * Draw;
   END;
   FOR L := 1 TO 2900 DO BEGIN
      C [L] := Exp (Random * 30 - 15) * Draw;
   END;
   FOR L := 1 TO 2900 DO BEGIN

      D [L] := round (C[L]);
      IF D [L] = 0 THEN
         Inc (D[L]);
   END;

   Write (#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8#8);

   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      I := J;
   END;
   StorageTime3 := Clock - Start;

   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := X;
   END;
   StorageTime := Clock - Start;

   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := X;
      X := Y;
   END;
   StorageTime2 := Round (0.75*(Clock - Start));

   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      I := (D [L] * D [2901-L]);
   END;
   ExecutionTime := Clock - Start - StorageTime3;
   WriteLn ('LONG-Mul              ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      I := (D [L] DIV D [2901-L]);
   END;
   ExecutionTime := Clock - Start - StorageTime3;
   WriteLn ('LONG-Div              ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      I := Abs (D [L]);
   END;
   ExecutionTime := Clock - Start - StorageTime3;
   WriteLn ('LONG-Abs              ', ExecutionTime/2.9:11:1, ' s');


   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := D [L];
   END;
   ExecutionTime := Clock - Start - StorageTime;
   WriteLn ('REAL-Float            ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := (C [L] + C [2901-L]);
   END;
   ExecutionTime := Clock - Start - StorageTime2;
   WriteLn ('REAL-Add              ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := (C [L] - C [2901-L]);
   END;
   ExecutionTime := Clock - Start - StorageTime2;
   WriteLn ('REAL-Sub              ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := (C [L] * C [2901-L]);
   END;
   ExecutionTime := Clock - Start - StorageTime2;
   WriteLn ('REAL-Mul              ', ExecutionTime/2.9:11:1, ' s');
   FOR L := 1 TO 2900 DO BEGIN
      D [L] := D [L] DIV 7440;
   END;
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := (C [L] * D [2901-L]);
   END;
   ExecutionTime := Clock - Start - StorageTime2;
   WriteLn ('REAL-Mul (Short)      ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := (C [L] / C [2901-L]);
   END;
   ExecutionTime := Clock - Start - StorageTime2;
   WriteLn ('REAL-Div              ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := Sqr(C [L]);
   END;
   ExecutionTime := Clock - Start - StorageTime;
   WriteLn ('REAL-Sqr              ', ExecutionTime/2.9:11:1, ' s');
   FOR L := 1 TO 2900 DO BEGIN
      C [L] := D [L];
   END;
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := Sqr(C [L]);
   END;
   ExecutionTime := Clock - Start - StorageTime;
   WriteLn ('REAL-Sqr (Short)      ', ExecutionTime/2.9:11:1, ' s');
   FOR L := 1 TO 2900 DO BEGIN
      C [L] := Exp (Random * 20 - 10) * Draw;
   END;
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := Int ( C[L]);
   END;
   ExecutionTime := Clock - Start - StorageTime;
   WriteLn ('REAL-Int              ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := Frac (C [L]);
   END;
   ExecutionTime := Clock - Start - StorageTime;
   WriteLn ('REAL-Frac             ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      I := Trunc (C [L]);
   END;
   ExecutionTime := Clock - Start - StorageTime3;
   WriteLn ('REAL-Trunc            ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      I := Round (C [L]);
   END;
   ExecutionTime := Clock - Start - StorageTime3;
   WriteLn ('REAL-Round            ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := Sqrt (A [L]);
   END;
   ExecutionTime := Clock - Start - StorageTime;
   WriteLn ('REAL-Sqrt             ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := Ln  (A [L]);
   END;
   ExecutionTime := Clock - Start - StorageTime;
   WriteLn ('REAL-Ln               ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := Exp (B [L]);
   END;
   ExecutionTime := Clock - Start - StorageTime;
   WriteLn ('REAL-Exp              ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := Sin (B[L]);
   END;
   ExecutionTime := Clock - Start - StorageTime;
   WriteLn ('REAL-Sin              ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := Cos (B[L]);
   END;
   ExecutionTime := Clock - Start - StorageTime;
   WriteLn ('REAL-Cos              ', ExecutionTime/2.9:11:1, ' s');
   Start := Clock;
   FOR L := 1 TO 2900 DO BEGIN
      Y := ArcTan (C[L]);
   END;
   ExecutionTime := Clock - Start - StorageTime;
   WriteLn ('REAL-ArcTan           ', ExecutionTime/2.9:11:1, ' s');
END. { AriTest }
