PROGRAM DenormTst; { Copyright (c) 1990-1993 Norbert Juffa }

{ DenormTst checks support and correct printing of denormals }

{$N+,E+}

VAR E: EXTENDED;
    D: DOUBLE;
    S: SINGLE;

BEGIN
   WriteLn ('Testing support and printing of denormals');
   WriteLn;
   Write ('Coprocessor is: ');
   CASE Test8087 OF
      0: WriteLn ('Emulator');
      1: WriteLn ('8087 or compatible');
      2: WriteLn ('80287 or compatible');
      3: WriteLn ('80387 or compatible');
   END;
   WriteLn;
   S := 1.18e-38;
   S := S * 3.90625e-3;
   IF S = 0 THEN
      WriteLn ('SINGLE denormals not supported')
   ELSE BEGIN
      WriteLn ('SINGLE denormals supported');
      WriteLn ('SINGLE denormal prints as:   ', S);
      WriteLn ('Denormal should be printed as 4.60943...E-0041');
   END;
   WriteLn;
   D := 2.24e-308;
   D := D * 3.90625e-3;
   IF D = 0 THEN
      WriteLn ('DOUBLE denormals not supported')
   ELSE BEGIN
      WriteLn ('DOUBLE denormals supported');
      WriteLn ('DOUBLE denormal prints as:   ', D);
      WriteLn ('Denormal should be printed as 8.75...E-0311');
   END;
   WriteLn;
   E := 3.37e-4932;
   E := E * 3.90625e-3;
   IF E = 0 THEN
      WriteLn ('EXTENDED denormals not supported')
   ELSE BEGIN
      WriteLn ('EXTENDED denormals supported');
      WriteLn ('EXTENDED denormal prints as: ', E);
      WriteLn ('Denormal should be printed as 1.3164...E-4934');
   END;
END.
